*** dqrep Wrapper to control data quality reports, version 1.34, July 2023  
*** Carsten Oliver Schmidt first version 2018 11, carsten.schmidt@uni-greifswald.de  
* version 1.3  	2023 03		First published version  
* version 1.31  2023 03		Improved log file output  
* version 1.32  2023 04		Improved handling of dataquieR limit conversion, improved limit metadata error output  
* version 1.33	2023 05		Improved checks for pointers in benchmark report, output text improvements		  
* version 1.34	2023 07		Improved result file output, layout improvements  
           
           
           
           
           
           
           
program define dqrep, rclass  
syntax   	[varlist] [if] [in]	, 																			///  
			/// DATA SOURCE AND FOLDERS																		///  
			/// Source directory for target study data files 												///  
			[sd(string)]																					///  
			/// Study Data file names																		///  
			[targetfiles(string)] 																			///	  
			/// Result directory 																			///  
			[rd(string)]																					///  
			/// Result data directory	- for individual level data results									///  
			[rdd(string)]																					///  
			/// Scalar result data directory - for data quality assessment results							///  
			[srdd(string)]																					///		  
			/// Data quality report target directory														///  
			[dqrd(string)]																					///  
			/// Directory for graphical results																///  
			[gd(string)]																					///  
			/// Directory for log files																		///  
			[ld(string)]																					///			  
			/// How to organize results related to subgroups in directory									///  
			[subgroupfolder(int 0)]																			///	  
			/// Whether to change variable names to lower letters or not, Default yes=1, no=0				///  
			[lowercase(int 1)]																				///  
			/// Store detailed results or not																///  
			[store]																							///				  
			///////////////////////////////////////////////////////////////////////////////////////////////////  
			/// Metadata																					///  
			/// Directory for help files to conduct data quality reports									///  
			[hd(string)]																					///  
			/// Name of the xlsx file that contains the data quality grades									///  
			[gradingfile(string)]																			///  
			/// Source directory of metadata files															///  
			[sdmd(string)]																					///  
			/// Metadata file name	 - Optional																///  
			[metadatafile(string)]																			///		  
			/// Interpretationtext file name	 - Optional													///  
			[interpretationtextfile(string)]																///			  
			/// use dataquieR metadatafile																	///  
			[dataquieR]																						///	  
			///////////////////////////////////////////////////////////////////////////////////////////////////  
			/// VARIABLES																					///  
			/// Primary variables for checking 																///	  
			[keyvars(string)] 																				///  
			/// Minorvars are variable that are not in a key role 								 			///  
			[minorvars(string)] 																			///			  
			/// Processvars are processvariables related to the process of the measurements		 			///  
			[processvars(string)]																			///			  
			/// Controll variables are variables used to control in regression analyses			 			///  
			[controlvars(string) ] 																			///			  
			/// Auxilliary variables Observer (obs), Device (dev), Time (time), Covariables (cv) 			///  
			[observervars(string) devicevars(string) centervars(string) timevars(string)] 					///			  
			/// ID Variables																	 			///  
			[idvars(string) ] 																				///  
			/// List of variables indicating participation variables 										///  
			[casemissvars(string) ] 																		///  
			/// Define the type of missing indicator variable												///  
			[casemisstype(string) ] 																		///			  
			/// Defines the logic to identify complete cases												///  
			[casemisslogic(string)]																			///  
			///////////////////////////////////////////////////////////////////////////////////////////////////  
			/// REPORT FORMATTING OUTPUT																	///  
			/// Report name 																				///  
			[reportname(string)] 																			///			  
			/// Segment name 																				///  
			[segmentname(string)] 																			///			  
			/// Included segments																			///  
			[segmentselect(string)] 																		///	  
			/// Excluded segments																			///  
			[segmentexclude(string)] 																		///  
			/// Select variables for report																	///  
			[varselect(string)] 																			///				  
			/// Title of the report to be displayed as the header of the report								///  
			[reporttitle(string)]																			///			  
			/// Subitle of the reort to be displayed as the header of the report							///  
			[reportsubtitle(string)]																		///	  
			/// pdf vs. docx 																				///  
			[reportformat(string)]																			///  
			/// Report template to output conent															///  
			[reporttemplate(string)]																		///  
			/// Report Authors 																				///  
			[authors(string)]																				///  
			/// Replace an existing report, 0=no, 1 all, 2 only pdf											///  
			[replacereport(int 0)]																			///  
			/// Maximum length of variable labels for better display 										///  
			[maxvarlabellength (int 40)]																	///  
			/// Output for interpretation part 																///  
			[view_interpretation (int 1)]																	///  
			/// Output for data integrity overview 															///  
			[view_integrity(int 1)] 																		///  
			/// Output for data quality indicator results overview											///  
			[view_dqi(int 1)] 																				///  
			/// Output for change logs																		///  
			[view_changelog(int 1)] 																		///			  
			/// Number of categories up to which a display takes place as a bar chart. 						///  
			[histkat (int 11)]																				///  
			/// Whether or not a page break is conducted after each variable 0=no 1 = yes 					///  
			[varlinebreak(int 1)]																			///  
			/// Whether or not a page break occurs after each table  0=no 1 = yes 							///  
			[sectionlinebreak(int 1)] 																		///  
			/// Number of lines required for a table to accept a pagebreak afterwards						///  
			[linenumberpagebreak(int 7)] 																	///  
			/// Colorassignement for colorpalettes															///  
			[clustercolorpalettes(string)] 																	///			  
			/// Requests maximum number of decimals for erport					 							///  
			[decimals(int 2)] 																				///	  
			/// Language setting																			///  
			[language (string)]																				///		  
			/// Modify width of graphs					 													///  
			[widthadd(int 0)] 																				///  
			/// Modify height of graphs					 													///  
			[heightadd(int 0)] 																				///  
			///////////////////////////////////////////////////////////////////////////////////////////////////  
			/// Textformatting																				///  
			/// Warncolor: The color of text in case of warning issues										///  
			[warncolor(string)]																				///				  
			///////////////////////////////////////////////////////////////////////////////////////////////////  
			/// ANALYSIS SETTINGS																			///  
			/// Whether or not new calculations are forced even if there is existing output 				///  
			[forcecalc(int 1)]																				///  
			/// Defines a subgroup with a logical expression							 					///  
			[subgroup(string)]																				///  
			/// Whether or not an allowed jump should be recoded to reference category (Default no recode) 	///  
			[jumpto0recode(int 0)]																			///  
			/// Provide a user made Missing list for recodings   											///  
			[itemmisslist(string)]																			///	  
			/// Provide a user made jump list for recodings													///  
			[itemjumplist(string)]																			///	  
			/// List of potential outlier checks to be performed											///  
			[outcheck(int 1)] 																				///		  
			/// Adjustment for the sensitivity which which outlier checks are performed						///  
			[outsens(int 1)] 																				///	  
			/// The way in which results from different checks are integrated								///  
			[outintegrate(int 1)] 																			///	  
			/// Number of categories up to which a categorical variable is recoded to  binary 				///  
			[binaryrecodelimit (int 8) ]																	///  
			/// Number of levels after which a variable is regarded as ratio/interval if no metadata		///  
			[metriclevels (int 25) ]																		///			  
			/// Minium N to compute a report																///  
			[minreportn(int 30)]																			///  
			/// Minium size of a cluster for inclution in ICC analyses										///  
			[minclustersize_icc(int 10)]																	///  
			/// Minium size of a cluster for inclusion in Lowess  analyses									///  
			[minclustersize_lowess(int 40)]																	///	  
			/// Minium number of events for calcualtions in lowess											///  
			[minevent_lowess(int 2)]																		///  
			/// Create a 2nd round for a report with all variables identified as problematic (Default0=no) 	///  
			[problemvarreport(int 0)]																		///  
			/// Minimum number of variables to conduct a report - to avoid nuisance reports				 	///  
			[minvarnum(int 1)]																				///  
			/// Request a benchmark report across different single reportstop							 	///  
			[benchmark(int 0)]																				///  
			/// No modification option to suppress variable modifications due to range violations ev	 	///  
			[nomod(int 0)]																					///  
			/// Default compression supressed to assess the original data types							 	///  
			[nocompress]																					///  
			///////////////////////////////////////////////////////////////////////////////////////////////////  
			/// Multiresult reporting																		///  
			/// Create reports from all loaded results 														///	  
			[resultreport(int 0)] 																			///	  
			/// Defines the variable to be used for multiresult reporting	NOTUSED CURRENTLY				///	  
			[rr_ordervar(string)]																			///	  
			///////////////////////////////////////////////////////////////////////////////////////////////////  
			/// Wether or not calculations are terminated in case of severe variable issues  				///  
			[breakreport(int 0)]																			///  
			///////////////////////////////////////////////////////////////////////////////////////////////////  
			/// TECHNICAL SETTINGS																			///  
			/// Defines the structural object, on which analyses are performed								///  
			[structure(string) ]																			///				  
			/// Defines the stratum only																	///  
			[ststrata(string) ]																				///  
			/// Defines the cluster only																	///  
			[stcluster(string) ]																			///  
			///////////////////////////////////////////////////////////////////////////////////////////////////  
			/// REPORTCALL SETTINGS																			///	  
			/// Parameter do decide whether or not to erase the macro space	0=no / 1 = yes					///  
			[erasemacro(int 1) ]																			///	  
			[not(varlist) sort ]  
           
capture version 15.1  
if _rc>0  local reportformat="noreport"  
capture log close _all  
global DQREPVERSION "dqrep version 1.34"  
local indent=0  
local adoname "dqrep"  
local text_i "di as text _n "  					  
di _n(4)   
`text_i' "Qualityreporter started  `c(current_time)' `c(current_date)'"  _n  
dq_hlp_syn,  indent(`indent')  
local sgnumber=			1									  
local subgroupreference "all"								  
local reportstop=		0									  
local problemfolder0 	""  
local problemfolder1 	"problemreport\"					  
local fullreportnumber	0									  
local errorreportnumber	0									  
local directuse 0											  
set linesize 160  
set varabbrev off  
foreach vartype in keyvars minorvars processvars controlvars timevars observervars devicevars centervars idvars subgroup casemissvars {  
	if `lowercase'==1 local `vartype'	= lower("``vartype''")  
}          
if ("`language'"~="d" & "`language'"~="e" & "`language'"~="p") local language="e"								  
local segmentname =trim("`segmentname'")  
if "`reportformat'"==""	local reportformat="pdf"										 					  
dq_set_txt, reportformat(`reportformat') widthadd(`widthadd') heightadd(`heightadd')  indent(`indent')		  
dq_set_tab1, outcheck(`outcheck') decimals(`decimals')  indent(`indent')	  
if "`subgroup'"=="" {  
	local subgroup "all"  
}          
local subgrouplist "`subgroup'"											  
foreach string in reportname reporttitle reportsubtitle authors {  
	local `string' =trim("``string''")		  
}          
local required_ados "matsum catplot colorpalette coefplot robstat grubbs" //add the required ados here//  
foreach adoname of local required_ados {  
	capture findfile `adoname'.ado,  
	if _rc==601 {  
		di as error "`adoname'.ado has not been found. Please install and restart."  
		if "`adoname'"=="robstat" di as error "robstat also requires moremata to run."  
		local reportstop=1  
	}         
}          
if `reportstop'==1 exit  
if  "`targetfiles'"~="" | "`metadatafile'"~="" {  
	`text_i' "A data source file has been specified and will be used."  
	local directuse 0  
}          
else local directuse 1  
if `directuse'==1 {  
	local directuse 1				  
	preserve  
	          
	marksample touse, novarlist  
	qui keep if `touse'  
	qui drop `touse'  
	if "`sort'" == "sort" {  
	  local varlist : list sort varlist  
	}         
	          
	if "`not'" != "" {  
	  capture confirm var `not'  
	  if _rc == 0 {  
		 unab not : `not'  
		 local varlist: list varlist - not  
	  }       
	  else {  
		 di as error "The specified exclusion Variables contain at least one non variable. Please check and restart."  
		 exit 190  
	  }       
	}         
	          
	qui keep `varlist'  
	          
	if "`keyvars'"=="" 	local keyvars 		"`varlist'"			  
		else 			local minorvars 	"`varlist'"			  
	if "`reporttemplate'"=="" local reporttemplate "D"			  
	          
	if "`sd'"=="" {  
		local sd="`c(pwd)'\"  
	}         
	local targetfiles =subinstr("`c(filename)'",".dta","__dqrep",1)	  
	save "`sd'\`targetfiles'", replace								  
}          
if "`targetfiles'"=="" & "`metadatafile'"=="" {  
	*** DQ_process_decision: DQ_INTcall_3  
	local reportstop=1  
	di as error "No study data file names have been provided. Please provide target file names and run Qualityreporter again!" _n(3)  
	          
}          
if "`segmentname'"=="" & (trim("`segmentselect'")~="" | trim("`segmentexclude'")~="")  {  
	*** DQ_process_decision: DQ_INTcall_3  
	local reportstop=1  
	di as error "No segment variable name has been provided but segments have been specified, use the segmentname option to specify the target variable!"  
	          
}          
if "`sd'"=="" {  
    local sd="`c(pwd)'\"  													  
	`text_i' "Data files are searched in the current working directory. Location: `sd'"  
}          
dq_fil_exc, cdir("`sd'") cfile() filetype(study data) breakreport(`breakreport')  indent(`indent')  
if `r(reportstop)'==1 exit  
if "`metadatafile'"~="" {  
	if "`sdmd'"=="" local sdmd="`sd'"  														  
	dq_fil_exc, cdir("`sdmd'") cfile(`metadatafile') filetype(Metadata file) breakreport(`breakreport')  indent(`indent')  
	if `reportstop'==0 local reportstop 	"`r(reportstop)'"								  
	          
	if "`segmentname'"~="" &  `r(reportstop)'==0 {  
		capture qui ds `segmentname'  
		local segchech=_rc  
		if `segchech'>0 {  
			*** DQ_process_decision: DQ_INTcall_3  
			local reportstop=1  
			di as error "No functioning segment variable name has been provided. Please provide correct segment variable name and run Qualityreporter again!"  
			        
		}        
		if `segchech'==0 & trim("`segmentselect'`segmentexclude'")=="" {  
			qui levelsof(`segmentname'), clean  
			`text_i' "A segment variable has been specified but nosegments to exclude or include, therefore all levels of `segmentname' will be treated as reports. The levels are:"  
			local segmentselect `"`r(levels)'"'  
			`text_i' `"`segmentselect'"'  
			local segchech=1   //trivially no segment check needed  
		}        
		         
		if `segchech'==0 & trim("`segmentselect'`segmentexclude'")~="" {  
			qui levelsof `segmentname', clean			  
			local segmentlist `"`r(levels)'"'  
			foreach string in segmentselect segmentexclude {  
				tokenize "``string''"  
				while "`1'"~="" {  
					if strpos(`"`segmentlist'"',"`1'")==0 {  
						*** DQ_process_decision: DQ_INTcall_3  
						local reportstop=1  
						di   
						di as error "Critical problem: Within segment variable the level `1' as specified in `string' is not available."  
						di as error "     Please provide correct segment value in option `string' and run Qualityreporter again!"  
						     
					}     
					      
					if strpos(`"`segmentlist'"',"`1'")>0 {  
					    if "`string'"=="segmentexclude" local segmentlist =subinstr(`"`segmentlist'"',"`1'","",1)  
				}      
					macro shift  
				}	     
			}       
		}        
	}         
}          
if "`hd'"=="" {  
    local hd="`sdmd'"  													  
	`text_i' "Help files for language and indicators are searched for in the metadatafile directory. Location: `hd'" _n  
}          
if wordcount("`timevars'")>1 {  
	*** DQ_process_decision: DQ_INTcall_4  
	local reportstop=1  
	di as error "Multiple Time variables provided instead of one time variable in the timevars option. Please correct and run dqrep again!"  
	          
}          
if  "`targetfiles'"~="" local targetfiles=subinstr("`targetfiles'",".dta","",.)  
if "`reportname'"~="" local reportname =subinstr("`reportname'"," ", "_",.)					  
	else local reportname="DQreport"														  
	          
if "`reporttitle'"=="" & "`keyvars'"=="" & "`metadatafile'"=="" & ("`reporttemplate'"=="" | "`reporttemplate'"=="D")  {  
	local reporttitle ="Descriptive data overview"  
	local reportname="DataReport"									  
}          
if "`keyvars'"~="" | "`metadatafile'"~="" | strtrim("`observervars'`devicevars'`timevars'")~=""  {  
	if "`reporttitle'"=="" local reporttitle ="Data quality report"  
	if "`reporttemplate'"=="" local reporttemplate="standard"  
}          
if "`reporttemplate'"==""  & strtrim("`keyvars'`minorvars'`processvars'`timevars'`metadatafile'")=="" /// 	  
							local reporttemplate "D" 										  
if "`reporttemplate'"=="" & strtrim("`keyvars'`minorvars'`processvars'`timevars'`metadatafile'")~="" ///  
							local reporttemplate "standard" 								  
if "`reporttemplate'"~="" {  
	local permittedtemplates "D M C A Q lowess outlier tables standard ship_standard nako_standard extended full var standard+ extended+ full+ var+"  
	local wrongtemplate =1																	  
	foreach t in `permittedtemplates' {  
		if strpos("`reporttemplate'","`t'")>0 {  
			local wrongtemplate =0		  
		}	       
	}         
	if `wrongtemplate'==1 {  
		di as error "No valid reporting template provided. Please correct and run dqrep again!"  
		         
		local reportstop=1  
	}         
}          
if `outcheck'>9 & `outcheck'~=`outintegrate' {  
	`text_i' "Unuseful outintegrate chosen, it will be set to outcheck!"  
	local outintegrate = `outcheck'  
}          
if `outcheck'~=`outintegrate' & `outintegrate'==1 {  
	local outintegrate = `outcheck'  
}          
if `outintegrate'==19 & `outcheck'<19 {  
	local outcheck==19  
	`text_i' "If decision on Tukey requested only Tukey assessed"  
}          
if `outintegrate'>10 & `outcheck'==1 {  
	local outintegrate==1  
	`text_i' "If adaptive approach chosen no individual checks can be chosen."  
}          
if `metriclevels'<5 {  
	`text_i' "A choice criterion for number of levels of etric variables has been set below 5. This is not useful, metriclevels reset to 25."  
	local metriclevels==25  
}          
if `reportstop'==1 {  
	di as error  "dqrep has terminated due to a critical issue, please check the reason in the output above and restart!"  
	exit						  
}          
if `resultreport' < 2 {  
	          
	if "`segmentselect'"~="" 	local segmentlist "`segmentselect'"				  
	if "`segmentlist'"=="" 		local segmentlist "nosegmentselect"				  
	di _n(3)  
	foreach segment of local segmentlist {  
		         
		         
		if `reportstop'==1 & `breakreport'==1 	exit		  
		         
		di _n(2)  
		if "`segment'"~="nosegmentselect" `text_i' `"Starting run for `reportname' with title `reporttitle' in segment `segment'"' _n  
		         
		local reportnamepass	"`reportname'"				  
		local reporttitlepass 	"`reporttitle'"				  
		foreach sg of local subgrouplist {  				  
			if "`sg'"~="all" local subgroupreference "sg`sgnumber'"	  
			        
			local reportstop=0								  
			        
			        
			forvalues reportrun=0/1 {  
			        
				if `reportstop'==0 		{															  
				       
					* Clean scalar macro space  
					clear mata  
					scalar drop _all  
					      
					if `reportrun'==0 | (`reportrun'==1 & `problemvarreport'>0) {  
						local problemvarreportpass=`reportrun'*`problemvarreport'   				  
						     
						     
						if `problemvarreportpass'>0 		local reportnamepass	"`reportname'_issuereport"		  
						if "`segment'"~="nosegmentselect" 	{  
							local reportnamepass		"`reportnamepass'_`segment'"  
							local reporttitlepass 		"`reporttitlepass' - `segment'"  
						}    
						     
						if `problemvarreportpass'>0 {  
							local reporttitlepass		"`reporttitlepass' $problemreportheader1"		  
							local reportsubtitlepass	"Report for variables with at least problem level: `problemvarreport'"		  
							local forcecalcpass=0	  
							local reporttemplatepass    "`reporttemplate'"	  
						}			  
						if `problemvarreportpass'==0 {  
							local reportsubtitlepass	"`reportsubtitle'"		  
							local forcecalcpass			"`forcecalc'"  
							local reporttemplatepass    "`reporttemplate'"	  
						}				  
				       
						     
						capture confirm file "`hd'\dq_set_lan.xlsx"  
						if _rc>0 {  
							if "`language'"=="d" 	dq_set_lger  
								else 				dq_set_leng		  
						}    
						if _rc==0 {  
							dq_fil_met, sd("`hd'\") metadatafile("dq_set_lan.xlsx") sheetname("dqtexts") infotype(1) language("`language'") ///  
													columnrequest("Language Texttype Textcontent")breakreport(`breakreport')  indent(`indent')	  
							if `r(reportstop)'==1 	local reportstop=1  
							if `r(reportstop)'==0  {  
								`text_i' "The selected report language is: $language_1"  
							}   
						}    
						     
						if "`reporttitle'"=="Descriptive data overview" local reporttitle ="$headertext_9"  
						if "`reporttitle'"=="Data quality report" 		local reporttitle ="$headertext_10"  
						     
																  
						dq_fil_odc , reportformat(`reportformat') reportname("`reportnamepass'") reporttitle("`reporttitlepass'")  reportsubtitle("`reportsubtitlepass'") ///  
												authors("`authors'")  indent(`indent')	  
						     
						if `resultreport'==1 & "`targetfiles'"=="" {  
							local targetfiles "Resultscalars_`reportnamepass'_`subgroupreference'_`reporttemplate'"  
						}    
						if "`rd'"=="" 	{	  
							*** DQ_process_decision: DQ_INTcall_1  
							dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) ///  
							colcontent1("$Note_1") colcontent2("$RD_1") colcontent3("$DQ_INTcall_warn_1")  indent(`indent')	  
							*** DQ_process_decision: DQ_INTcall_1  
							dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) ///  
							colcontent1("$Action_1") colcontent2("$RD_1") colcontent3("$DQ_INTcall_action_1 `c(pwd)'")  indent(`indent')					  
						}    
						     
						if `subgroupfolder'==0 local subgroupreferencepass ""  
						if `subgroupfolder'==1 local subgroupreferencepass "`segment'_`subgroupreference'"	  
						if `subgroupfolder'==1 & `reportrun'==1  local subgroupreferencepass "`segment'_`subgroupreference'\issues"			  
					      
						dq_fil_dir, tad("`rd'") dsd("`subgroupreferencepass'") sd(`sd') red("`sd'DQ_resultsfolder\") purpose("dq result data folder")  indent(`indent')  
							local rd 			"`r(tad)'"  
							if `reportstop'==0 local reportstop "`r(reportstop)'"						  
							local rd_old 			"`rd'"												  
						     
						if "`store'"=="store" | "`rdd'"~="" {  
							dq_fil_dir, tad("`rdd'") dsd("`subgroupreferencepass'") sd(`sd') red("`rd'_dataresultfiles\") purpose("result study data folder") supdsd(`reportrun')  indent(`indent')  
								local rdd 			"`r(tad)'"  
								if `reportstop'==0 local reportstop 	"`r(reportstop)'"				  
						}    
											  
						dq_fil_dir, tad("`dqrd'") dsd("`subgroupreferencepass'") sd(`sd') red("`rd'") purpose("data quality report target directory") modred(0) supdsd(`reportrun')  indent(`indent')  
							local dqrd 			"`r(tad)'"  
							if `reportstop'==0 local reportstop 	"`r(reportstop)'"					  
								   
						if "`srdd'"=="" & 	"`store'"=="" local srdd 	"`rd'\____deletef\"  
						if "`gd'"=="" 	& 	"`store'"=="" local gd 		"`rd'\____deletef\"  
						if 					"`store'"=="" local gdth 	"`rd'\____deletef\"				  
						if 					"`store'"=="" local gddq 	"`rd'\____deletef\"				  
						     
						     
						* Check and generate scalar result data directory	  
						dq_fil_dir, tad("`srdd'") dsd("`subgroupreferencepass'") sd(`sd') red("`rd'_dataresultfiles\") purpose("scalar result data directory") modred(0)  supdsd(`reportrun')  indent(`indent')  
							local srdd 			"`r(tad)'"  
							if `reportstop'==0 local reportstop 	"`r(reportstop)'"					  
							    
						dq_fil_dir, tad("`gd'") dsd("`subgroupreferencepass'") sd(`sd') red("`rd'graph\") purpose("graph result directory") modred(0) supdsd(`reportrun')  indent(`indent')  
							local gd 			"`r(tad)'"  
							if `reportstop'==0 local reportstop 	"`r(reportstop)'"					  
						if "`gdth'"=="" {  
							local gdth "`gd'\thumbs\"						  
							dq_fil_dir, tad("`gdth'") dsd("") sd(`sd') red("") purpose("graph thumbs result directory")  supdsd(`reportrun')  indent(`indent')  
								if `reportstop'==0 local reportstop 	"`r(reportstop)'"					  
						}    
						if "`gddq'"=="" {		  
							local gddq "`gd'\dqi_`reportnamepass'\"			  
							dq_fil_dir, tad("`gddq'") dsd("") sd(`sd') red("") purpose("dqi graphs related output directory")  supdsd(`reportrun')  indent(`indent')  
								if `reportstop'==0 local reportstop 	"`r(reportstop)'"					  
						}    
							    
						dq_fil_dir, tad("`ld'") dsd("`subgroupreferencepass'") sd(`sd') red("`rd'") purpose("log file directory") modred(0)  supdsd(`reportrun')  indent(`indent')  
							local ld 			"`r(tad)'"  
							if `reportstop'==0 local reportstop 	"`r(reportstop)'"					  
						if `reportstop'==1 & `breakreport'==1 	exit						  
						     
						if `reportstop'==0 {  
					      
							log using "`ld'\dq_logfile_`reportnamepass'_`reporttemplate' $S_DATE.txt",  replace name(qsanalyses_txt)  text  
							    
							di _n(2)  
							`text_i'  "Start data quality report generation for report `reportnamepass' $S_TIME"  _n  
							* 2. dq_report takes charge of the data quality report generation  
							    
							`text_i' `"Information on settings for the report that is generated:"'	_n		  
							    
							`text_i' "Report name for storage" 											_column(40) "`reportnamepass'"	  
							`text_i' "Report title" 													_column(40) "`reporttitle'"	  
							`text_i' "Data source directory" 											_column(40) "`sd'"	  
							`text_i' "Result main directory" 											_column(40) "`rd'"	  
							if "`rdd'"=="" `text_i' "Result data file directory" 						_column(40) "Not specified"	  
							if "`rdd'"~="" `text_i' "Result data file directory" 						_column(40) "`rdd'"	  
							if strpos("`srdd'","__deletef")==0 `text_i' "Scalar results directory" 		_column(40) "`srdd'"	  
							`text_i' "Data quality report target directory" 							_column(40) "`dqrd'"	  
							if strpos("`gd'","__deletef")==0 `text_i' "Graphical results directory" 	_column(40) "`gd'"	  
							`text_i' "Log file directory" 												_column(40) "`ld'"	  
							if "`sdmd'"=="" `text_i' "Metadata file directory" 							_column(40) "Not specified"  
							if "`sdmd'"~="" `text_i' "Metadata file directory" 							_column(40) "`sdmd'"  
							`text_i' "The report name is" 												_column(40) "`reportnamepass'"	  
							`text_i' "The report title is" 												_column(40) "`reporttitle'"	  
							if "`reportsubtitle'"=="" `text_i' "The report subtitle is" 				_column(40) "Not specified"	  
							if "`reportsubtitle'"~="" `text_i' "The report subtitle is" 				_column(40) "`reportsubtitle'"  
							if "`sg'"~="all" `text_i'  "Analyses for subgroup `sg' in report run `reportrun'" _n		  
							di  
							if `resultreport'==1 {  
								local minreportnpass=1				  
							}	  
							else local minreportnpass=`minreportn'		  
							    
							if "`gradingfile'" ~="" {  
								capture confirm file "`hd'\`gradingfile'"  
								if _rc>0 {  
									di as error "The indicator definitions in file `gradingfile' for report conduct are not available, please correct and rerun!"  
									  
									local reportstop=1  
								}  
					      
								if _rc==0 {  
									dq_fil_met, sd("`hd'\") metadatafile("`gradingfile'") sheetname("dqindicators") macroextensionname("_mddq") infotype(2)  indent(`indent')  
									if `r(reportstop)'==1 	local reportstop=1  
								}  
								   
								   
							}   
							else dq_set_ind			  
							    
							if `reportstop'==1  {  
								log close _all  
								exit, clear  
							}		  
						     
							    
						     
							dq_set_mat, reporttemplate(`reporttemplate') resultreport(`resultreport') problemvarreport(`problemvarreportpass') benchmark(`benchmark')  indent(`indent')	  
							if `view_interpretation'~=0 local view_interpretation	= r(view_interpretation)		  
							if `view_integrity'~=0 		local view_integrity		= r(view_integrity)				  
							if `view_dqi'~=0 			local view_dqi				= r(view_dqi)					  
							if `view_changelog'~=0 		local view_changelog		= r(view_changelog)				  
							if "`interpretationtextfile'"=="" local view_interpretation	= 0  
						     
							**** Data quality reporting function dq_report is executed  
							set rmsg on							  
		         
							dq_report , 																				///  
								/// Directories and file names															///  
								sd							("`sd'") 													///  
								hd							("`hd'") 													///  
								rd							("`rd'")		 											///			  
								rdd							("`rdd'")		 											///	  
								srdd						("`srdd'")		 											///	  
								gd							("`gd'")		 											///			  
								gdth						("`gdth'")		 											///			  
								gddq						("`gddq'")		 											///			  
								ld							("`ld'") 													///  
								targetfiles					("`targetfiles'") 											///	  
								sdmd						("`sdmd'") 													///  
								metadatafile				("`metadatafile'")  										///	  
								interpretationtextfile		("`interpretationtextfile'")  								///	  
								subgroupreference			("`subgroupreference'")  									///	  
								lowercase					(`lowercase')  												///	  
								/// Variables																			///  
								keyvars						("`keyvars'")												///  
								minorvars					("`minorvars'")												///  
								processvars					("`processvars'")											///	  
								observervars 				("`observervars'")											///  
								devicevars					("`devicevars'") 											///  
								centervars					("`centervars'") 											///  
								timevars					("`timevars'")												///  
								controlvars					("`controlvars'") 											///  
								idvars						("`idvars'") 												///  
								casemissvars				("`casemissvars'") 											///  
								casemisstype				("`casemisstype'") 											///  
								casemisslogic				("`casemisslogic'") 										///  
								/// Reportformatting																	///  
								reportname					("`reportnamepass'") 										///  
								segmentname					("`segmentname'")											///  
								segmentselect				("`segment'")												///  
								varselect					("`varselect'")												///  
								reporttitle					("`reporttitlepass'")										///			  
								reportsubtitle				("`reportsubtitlepass'")									///	  
								reportformat				("`reportformat'")	 										///  
								reporttemplate 				("`reporttemplatepass'") 									///	  
								maxvarlabellength 			(`maxvarlabellength')										///  
								view_interpretation			(`view_interpretation')										///  
								view_dqi					(`view_dqi')												///  
								view_integrity				(`view_integrity')											///  
								view_changelog				(`view_changelog')											///  
								histkat 					(`histkat')													///	  
								varlinebreak				(`varlinebreak')											///	  
								sectionlinebreak			(`sectionlinebreak')										///	  
								linenumberpagebreak			(`linenumberpagebreak')										///  
								clustercolorpalettes		(`clustercolorpalettes')									///  
								decimals					(`decimals')												///  
								replacereport				(`replacereport')											///	  
								/// Textformatting																		///  
								warncolor					(`warncolor')												///				  
								/// Analysevorgaben 																	///  
								forcecalc					(`forcecalcpass')											///  
								subgroup					("`sg'")													///  
								jumpto0recode				(`jumpto0recode')											///  
								itemmisslist				("`itemmisslist'")											///  
								itemjumplist				("`itemjumplist'")											///  
								outcheck					(`outcheck')												///  
								outsens						(`outsens') 												///  
								outintegrate				(`outintegrate')											///  
								binaryrecodelimit 			(`binaryrecodelimit') 										///  
								metriclevels 				(`metriclevels') 											///  
								minreportn					(`minreportnpass') 											/// 	  
								minclustersize_icc			(`minclustersize_icc')										///	  
								minclustersize_lowess 		(`minclustersize_lowess')									///	  
								minevent_lowess 			(`minevent_lowess')											///	  
								problemvarreport 			(`problemvarreportpass')									///	  
								minvarnum		 			(`minvarnum')												///	  
								nomod						(`nomod')													///  
								`nocompress'																			///  
								/// Multiresult reporting		 														///	  
								resultreport				(`resultreport') 											///	  
								rr_ordervar					(`rr_ordervar')												///	  
								/// Debugging, Program stops															///  
								breakreport					(`breakreport')												///  
																								///								  
								indent 						(1)															///						  
								/// Technical settings																	///  
								structure					("`structure'")  											///															  
								ststrata					("`ststrata'")  											///				  
								stcluster					("`stcluster'")  			`dataquieR'  
							    
							set rmsg off  
							local reportstop=`r(reportstop)'  
							    
							**** End of dq_report, close open settings  
							if "`r(reportname)'"~="`reportnamepass'"  {  
								`text_i' "The changed reportname is: `r(reportname)'" _n  
							}   
							    
							if `reportstop'==0 & `reportrun'==0 {  
								local ++fullreportnumber  
								local resultfilellist "`resultfilellist' Resultscalars_`reportnamepass'_`subgroupreference'_`reporttemplate'_long"  
							}   
							if `reportstop'==1 local ++errorreportnumber  
						}    
						if "`reportformat'"~="noreport" {  
							dq_fil_cld, reportname("`reportnamepass'") reportstop(`reportstop') reporttemplate(`reporttemplate') reportformat(`reportformat') dqrd(`dqrd') subgroupreference(`subgroupreference')  indent(`indent')  
						}    
						     
						local rd "`rd_old'"					  
					}     
				       
					capture log close qsanalyses_txt	  
			        
				}	     
			}       
			local ++sgnumber									  
		}        
		di _n(2)  
		scalar drop _all  
	}         
	          
}          
if ((`benchmark'>0 & `fullreportnumber'>1) | (`benchmark'>0 & `resultreport'==2)) & "`reportformat'"~="noreport"  {		  
	if `resultreport'==2 {  
		local resultfilellist="`targetfiles'"  
		local problemvarreportpass=0  
		local dqrd="`rd'\"  
		local ld="`rd'"  
	}         
	log using "`ld'\dq_logfile_`reportname'_benchmark $S_DATE.txt",  replace name(qsbenchmark)  text  
	local reportstop=0																				  
	if "`store'"=="" 		local gddq	"`rd'\____deletef\"											  
	if "`store'"=="store" 	local gddq  "`gd'\dqi_`reportname'_benchmark\"							  
	dq_fil_dir, tad("`gddq'") dsd("") sd(`sd') red("") purpose("graph result directory") modred(0)   indent(`indent')  
		if `reportstop'==0 local reportstop 	"`r(reportstop)'"									  
	          
    `text_i' "Generate the benchmark report: `reportname'_benchmark"  
	dq_fil_odc , reportformat(`reportformat')  reportname("`reportname'_benchmark") reporttitle("`reporttitle' - $resultreport_2")  reportsubtitle("`reportsubtitlepass'")  authors("`authors'")  indent(`indent')	  
	          
	capture confirm file "`hd'\dq_set_ind.xlsx"  
	if _rc>0 {  
		`text_i' "The indicator definitions in file dq_set_ind.xlsx for report conduct are not available, default settings are loaded!"  
		dq_set_ind  
	}         
	if _rc==0 {  
		dq_fil_met, sd("`hd'\") metadatafile("dq_set_ind.xlsx") sheetname("dqindicators") macroextensionname("_mddq") infotype(2)  indent(`indent')					  
		if `r(reportstop)'==1 	local reportstop=1  
		if `reportstop'==1  	exit	  
	}         
	          
	dq_set_mat, reporttemplate(benchmark) resultreport(1) problemvarreport(`problemvarreportpass') benchmark(`benchmark')  indent(`indent')	  
	if `view_interpretation'~=0 local view_interpretation	= r(view_interpretation)		  
	if `view_integrity'~=0 		local view_integrity		= r(view_integrity)				  
	if `view_dqi'~=0 			local view_dqi				= r(view_dqi)					  
	if `view_changelog'~=0 		local view_changelog		= r(view_changelog)				  
	          
	          
	`text_i'   "Benchmarking conducted for the following files: `resultfilellist'" _n  
	          
    dq_report	, srdd(`srdd') gd(`gd') gdth(`gdth') gddq(`gddq') rd(`rd') targetfiles(`resultfilellist') reportname("`reportname'_benchmark") reporttitle("`reporttitle' - benchmark $report_1")  reportsubtitle("`reportsubtitlepass'")  ///  
				  reportformat("`reportformat'") varlinebreak(0) sectionlinebreak(0) replacereport(0) resultreport(1) benchmark(`benchmark')  indent(`indent')  
	          
	dq_fil_cld, reportname("`reportname'_benchmark") reportstop(`reportstop') reporttemplate(`reporttemplate') reportformat(`reportformat') dqrd(`dqrd') subgroupreference(`subgroupreference')  indent(`indent')  
	          
	`text_i' "A benchmark report to compare quality reports was generated."  
	capture log close qsbenchmark	  
}          
if "`store'"=="" {  
	shell erase "`rd'\____deletef\*.png"  
	shell erase "`rd'\____deletef\*.txt"  
	shell erase "`rd'\____deletef\*.xlsx"  
	shell erase "`rd'\____deletef\*.dta"  
	shell erase "`rd'\____deletef\*.csv"  
	rmdir "`rd'\____deletef"  
} //End check delete folder created because extensive output not to be stored					  
if "`erasemacro'"=="erasemacro" {  
	macro drop _all  
	scalar drop _all  
}          
if `directuse'==1 {  
    restore  
	qui erase "`sd'\`targetfiles'.dta"  
}          
capture log close _all  
`text_i' "The number of generated quality reports was:" 						_column(70) "`fullreportnumber'"  
if `problemvarreport'>0 `text_i' "The number of generated issue reports was:" 	_column(70) "`fullreportnumber'"  
`text_i' "The number of generated error reports was:"   						_column(70) "`errorreportnumber'"  
if ((`benchmark'>0 & `fullreportnumber'>1) | (`benchmark'>0 & `resultreport'==2)) & "`reportformat'"~="noreport" `text_i' "A benchmark report was created."  
di _n(2)   
end        
